#include <bits/stdc++.h>

using namespace std;


struct Tacka { 
    long long int x, y; 
    bool operator<(const Tacka& p) const { 
        return x < p.x || (x == p.x && y < p.y); 
        } 
    }; 
    
int pol(const Tacka& O, const Tacka& A, const Tacka& B) { 
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x); 
    } 

vector<Tacka> konveksni(vector<Tacka>& P) { 
    long long int n = P.size(), k = 0; 
    vector<Tacka> H(2 * n); 
    sort(P.begin(), P.end()); 

    for (long long int i = 0; i < n; ++i) { 
        while (k >= 2 && pol(H[k - 2], H[k - 1], P[i]) <= 0) 
            k--; 
        H[k++] = P[i]; 
        } 

        for (long long int i = n - 1, t = k + 1; i >= 0; --i) { 
            while (k >= t && pol(H[k - 2], H[k - 1], P[i]) <= 0) 
                k--; 
            H[k++] = P[i]; 
            } 

            H.resize(k - 1); 

    return H; 
} 


double PoligonP(const vector<Tacka>& P) { 
    long double p = 0; 
    long long int n = P.size(); 
    for (int i = 0; i < n; i++) { 
        int j = (i + 1) % n; 
            p += P[i].x * P[j].y - P[j].x * P[i].y; 
        } 
        return abs(p) / 2.0; 
} 
            
int main() { 
    long long int n; 
    cin >> n; 
    vector<Tacka> tacke(n); 
    for (long long int i = 0; i < n; i++) { 
        cin >> tacke[i].x >> tacke[i].y; 
        } 
        long long minP = numeric_limits<long double>::max(); 
        for (long long int i = 0; i < n; i++) { 
            vector<Tacka> reducedPoints; 
            for (long long int j = 0; j < n; j++) { 
                if (i != j) { 
                    reducedPoints.push_back(tacke[j]); 
                } 
            } 
            vector<Tacka> trup = konveksni(reducedPoints); 
            long double pov = PoligonP(trup); 
            if (pov < minP) { 
                minP = pov; 
            } 
        } 
        cout << static_cast<int>(minP) << endl; 
        
        return 0;
}